<?php
global $data;
// Do not delete these lines
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php _e('This post is password protected. Enter the password to view comments.', 'Nimva') ?></p>
	<?php
		return;
	}

/*-----------------------------------------------------------------------------------*/
/*	Display the comments + Pings
/*-----------------------------------------------------------------------------------*/

		if ( have_comments() ) : // if there are comments ?>
        
        <?php if ( ! empty($comments_by_type['comment']) ) : // if there are normal comments ?>
		
		<div class="title-outer"><h3><?php _e('Commenting area', 'Nimva'); ?></h3></div>
		
		<ol class="commentlist clearfix">
		<?php wp_list_comments('type=comment&callback=comment_style'); ?>
        </ol>
        
        <div class="clear"></div>

        <?php endif; ?>

        <?php if ( ! empty($comments_by_type['pings']) ) : // if there are pings ?>
		
		<h3 id="pings"><?php _e('Trackbacks for this post', 'Nimva') ?></h3>
		
		<ol class="pinglist">
        <?php wp_list_comments('type=pings&callback=tz_list_pings'); ?>
        </ol>

        <?php endif; ?>

		<?php
		
		
/*-----------------------------------------------------------------------------------*/
/*	Deal with no comments or closed comments
/*-----------------------------------------------------------------------------------*/
		
		if ('closed' == $post->comment_status ) : // if the post has comments but comments are now closed ?>
		
		<p class="nocomments"><?php _e('Comments are now closed for this article.', 'Nimva') ?></p>
		
		<?php endif; ?>

 		<?php else :  ?>
		
        <?php if ('open' == $post->comment_status) : // if comments are open but no comments so far ?>

        <?php else : // if comments are closed ?>
		
		<?php if (is_single()) { ?><p class="nocomments"><?php _e('Comments are closed.', 'Nimva') ?></p><?php } ?>

        <?php endif; ?>
        
<?php endif;


/*-----------------------------------------------------------------------------------*/
/*	Comment Form
/*-----------------------------------------------------------------------------------*/

	if ( comments_open() ) : 

		$c_style =  ($data['comment_style'] == '3D') ? 'simple-button-3d' : 'simple-button';
		$c_color = $data['comment_color'];
		if($c_color == 'Light Red' ) $c_color='red';
		if($c_color == 'Light Blue' ) $c_color='blue';
		$c_size = ($data['comment_size'] == 'Small') ? 'small' : 'large';
		$c_icon = ($data['comment_icon'] != '' ) ? '<i class="fa ' . $data['comment_icon'] . '"></i>' : '';

		$button_class = $c_style.' '.strtolower(str_replace(" ","_",$c_color)).' '.$c_size;

		/*<button name="submit" type="submit" id="submit-button" tabindex="5" value="Submit" class="<?php echo $c_style.' '.strtolower(str_replace(" ","_",$c_color)).' '.$c_size; ?>"><?php _e($c_icon.'Submit Comment', 'Nimva') ?></button>*/

		$args = array(
			'id_form'           => 'commentform',
			'id_submit'         => 'submit',
			'title_reply'       => '<div class="title-outer"><h3>' . __('Leave a Reply', 'Nimva') . '</h3></div>',
			'title_reply_to'    => '<div class="title-outer"><h3>' . __('Leave a Reply to %s', 'Nimva') . '</h3></div>',
			'cancel_reply_link' => __( 'Cancel Reply', 'Nimva' ),
			//'label_submit'      => __( 'Submit Comment', 'Nimva' ),
			//'class_submit'		=> $button_class,
			'submit_button'		=> '<button name="submit" type="submit" id="submit-button" tabindex="5" value="Submit" class="' . $button_class . '">' . __($c_icon.'Submit Comment', 'Nimva') . '</button>',
			'comment_field' =>  '<div class="col_full"><textarea name="comment" id="comment" cols="58" rows="10" tabindex="4" class="input-block-level"></textarea></div>',
			'must_log_in' => '<p class="must-log-in">' .
			  sprintf(
			    __( 'You must be <a href="%s">logged in</a> to post a comment.', 'Nimva' ),
			    wp_login_url( apply_filters( 'the_permalink', get_permalink() ) )
			  ) . '</p>',

			'logged_in_as' => '<div class="col_full">' . '<p>' .
			  sprintf(
			  __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'Nimva' ),
			    admin_url( 'profile.php' ),
			    $user_identity,
			    wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) )
			  ) . '</p>' . '</div>',

			'comment_notes_before' => '',

			'comment_notes_after' => '',

			'fields' => apply_filters( 'comment_form_default_fields', array(
				'author' =>
					'<div class="col_one_third">'. 
		            	'<label for="author">' . __('Name ', 'Nimva'). '<span>'. __("*", 'Nimva') . '</span></label> ' .
		                '<input type="text" name="author" id="author" value="' . esc_attr( $commenter['comment_author'] ) .'" size="22" tabindex="1" class="input-block-level" />
		            </div>',									

				'email' =>
					'<div class="col_one_third">'.
						'<label for="email">' . __('Email ', 'Nimva'). '<span>'. __("*", 'Nimva') . '</span> <small>(' . __('will not be published','Nimva'). ')</small></label> ' .
					 '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="22" tabindex="2" class="input-block-level">'.
					 '</div>',
				'url' => 
					'<div class="col_one_third col_last">'.
						'<label for="url">' . __('Website', 'Nimva') . '</label>'.
						'<input type="text" name="url" id="url" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="22" tabindex="3" class="input-block-level" />'.
					'</div>',
				)
					
			),
		);
		comment_form($args);

	?>

	<?php endif; // if you delete this the sky will fall on your head ?>
